//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.9 Page 494
//Title: Rate of condensate formation
//======================================================

model Ex11_9
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = " C ") = 84 " Surface temperature ";
parameter Real L(unit = " m ") = 2 " Length of tube "; 
parameter Real d(unit = " m ") = 2.5e-2 " Diameter of tube ";

//Properties of Saturated Vapour at 100 degree celsius
parameter Real Tsat(unit = "C") =100 " Temperature saturated ";
parameter Real pv(unit = "kg/m^3" )=0.596 " Density of steam ";
parameter Real hfg(unit = "kJ/kg" )=2257 " Enthalpy of steam ";

//Saturated Water at Film Temperature of 92 degree celsius
parameter Real pl(unit = "kg/m^3" )=963.4 " Density of water ";
parameter Real ul(unit = "Pa s" )=306e-6 " Viscosity of water ";
parameter Real kl(unit = "W/m K" )=677e-3 " Thermal Conductivity of water ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real hl(unit= "W/m^2 K") " Local Heat transfer coefficient ";
Real m(unit= "kg/hr") " Mass flow rate of condensate ";
Real Q(unit ="kW/m") "Heat transfer rate ";


//=============
// Equation Section

equation

hl=0.725*( (g_n*pl*(pl-pv)*kl^3*hfg*1e3) / (ul*(Tsat-T)*d) )^0.25;
Q=hl*(pi*d)*(Tsat-T)/1e3;
m=Q*3600/(hfg);

end Ex11_9;
//======================================================
