//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.16 Page 532
//Title: Oil and Water outlet temperature
//======================================================

model Ex12_16
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Thi(unit = " C ") = 110 " Oil inlet temperature";
parameter Real Tci(unit = " C ") = 35 " Cold Water inlet temperature";
parameter Real mh(unit = " kg/min ") = 170.9 " Oil flow rate";
parameter Real mc(unit = " kg/min ") = 68 " Cold Water flow rate";
parameter Real cph(unit = " J/kg K ") = 1900 " Oil specific heat capacity";
parameter Real cpc(unit = " J/kg K ") = 4186 " Cold Water specific heat capacity";
parameter Real Uo(unit = " W/ m^2 K ") =320 " Overall heat transfer coefficient";
parameter Real A(unit ="m^2")=15.82 " Area of heat exchanger";
parameter Real E(unit= "")=0.92 " Effectiveness "; //From fig 12.18 on page 526

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tho(unit = " C ") " Hot oil outlet temperature";
Real Tco(unit = " C ") " Cold Water outlet temperature";
Real Ch(unit = " W/K ") " Hot oil heat capacity";
Real Cc(unit = " W/K ") " Cold Water heat capacity";
Real D(unit = " ") " Constant";

//=============
// Equation Section

equation

Ch=mh*cph/60;
Cc=mc*cpc/60;
D=(Uo*A)*((1/Ch) - (1/Cc));
Tho=Thi - (Thi-Tci)*(1-e^D)/((Ch/Cc)-e^D);
Tco=Tci+(Ch/Cc)*(Thi-Tho);

end Ex12_16;
//======================================================
