//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.17 Page 533
//Title: New Outlet Temperature
//======================================================

model Ex12_17
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Ts(unit = " C ") = 120 " Steam temperature";
parameter Real Tci[2](unit = " C ") = {20,15} " Initial and Final Cold Water inlet temperature";
parameter Real Tco(unit = " C ") = 50 " Cold Water outlet temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tco2(unit = " C ") " Cold Water outlet temperature";

//=============
// Equation Section

equation

(Tco-Tci[1])/(Ts-Tci[1])=(Tco2-Tci[2])/(Ts-Tci[2]);

end Ex12_17;
//======================================================
