//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.6 Page 512
//Title: Area of condenser
//======================================================

model Ex12_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real mc(unit = " kg/hour ") = 1000 " Water flow rate";
parameter Real Cpc(unit = " J/ kg K ") = 4186 " Water specific heat capacity";
parameter Real U(unit = " W/ m^2 K ") = 1800 " Overall heat transfer coefficient";
parameter Real Tc[2](unit = " C ") = {20,90} " Water inlet and outlet temperatures respectively ";
parameter Real Ts(unit = " C ") = 120 " Temperature of saturated steam ";
parameter Real hfg(unit = " kJ/kg ") = 2200 " Latent Heat of saturated steam ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit= "W ")" Heat transfer rate";
Real A(unit= "m^2 ")" Area of heat exchanger";
Real Tlmtd(unit = " C ") "Log Mean temperature difference ";
Real ms(unit = " kg/hour ")" Steam condensation rate";

//=============
// Equation Section

equation

Q=mc*Cpc*(Tc[2]-Tc[1])/3600;
Tlmtd=((Ts-Tc[2])-(Ts-Tc[1]))/(log((Ts-Tc[2])/(Ts-Tc[1])));
Q= U*A*Tlmtd;
Q*3600=ms*hfg*1000;

end Ex12_6;
//======================================================
