//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.1 Page 544
//Title: Average molecular weight
//======================================================

model Ex13_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real rO2(unit = "") = 0.21 " Ratio of Oxygen";
parameter Real rN2(unit = "") = 0.79 " Ratio of Nitrogen";
parameter Real T(unit= "C")=25 "Temperature of the mixture ";
parameter Real P(unit= "bar")=1 "Pressure of the mixture ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real CO2(unit = " kmol/m^3 ") " Molar concentration of O2";
Real CN2(unit = " kmol/m^3 ") " Molar concentration of N2";
Real p1[2](unit= "kg/m^3")" Density of oxygen and nitrogen respectively ";
Real P1(unit= "kg/m^3")" Overall mass density ";
Real mO2(unit = "") " Mass fraction of oxygen";
Real mN2(unit = "") " Mass fraction of nitrogen";
Real M(unit= "kg/kmol")" Average molar mass"; 

//=============
// Equation Section

equation

CO2=(P*rO2*1e5)/((8.314e3)*(T+273));
CN2=(P*rN2*1e5)/((8.314e3)*(T+273));
p1[1]=32*CO2;
p1[2]=28*CN2;
P1=p1[1]+p1[2];
mO2=p1[1]/P1;
mN2=p1[2]/P1;
M=(rO2*32)+(rN2*28);

end Ex13_1;
//======================================================
