//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.2 Page 545
//Title: Mass and molar average velocities and flux
//======================================================

model Ex13_2
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real yH2(unit = "") = 0.4 " Mole fraction of Hydrogen";
parameter Real yO2(unit = "") = 0.6 " Mole fraction of Oxygen";
parameter Real vH2(unit= "m/s")=1 " Velocity of Hydrogen ";
parameter Real vO2(unit= "m/s")=0 " Velocity of Oxygen ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real V1(unit = " m/s ") " Molar average velocity";
Real V2(unit = " m/s ") " Mass average velocity";
Real mO2(unit = "") " Mass fraction of oxygen";
Real mH2(unit = "") " Mass fraction of hydrogen";
Real M(unit= "kg/kmol")" Average molar mass"; 
Real nH2(unit= "Rho*kg/m^2 s") " Mass Flux of Hydrogen"; 
Real nO2(unit= "Rho*kg/m^2 s") " Mass Flux of Oxygen";
Real NH2(unit= "C*kmol/m^2 s") " Molar Flux of Hydrogen"; 
Real NO2(unit= "C*kmol/m^2 s") " Molar Flux of Oxygen";
Real jH2(unit= "Rho*kg/m^2 s") " Mass Diffusion Flux of Hydrogen with mass average velocity"; 
Real jO2(unit= "Rho*kg/m^2 s") " Mass Diffusion Flux of Oxygen with mass average velocity";
Real JH2(unit= "C*kmol/m^2 s") " Molar Diffusion Flux of Hydrogen with molar average velcoity";
Real JO2(unit= "C*kmol/m^2 s") " Molar Diffusion Flux of Oxygen with molar average velocity";

//=============
// Equation Section

equation

M=(yO2*32)+(yH2*2);
mO2=yO2*32/M;
mH2=yH2*2/M;
V1=(yO2*vO2)+(yH2*vH2);
V2=(mO2*vO2)+(mH2*vH2);
nH2=mH2*vH2;
nO2=mO2*vO2;
NH2=yH2*vH2;
NO2=yO2*vO2;
jH2=mH2*(vH2-V2);
jO2=mO2*(vO2-V2);
JH2=yH2*(vH2-V1);
JO2=yO2*(vO2-V1);

//Error in value of NH2. It is 0.4Ckmol/m^2s

end Ex13_2;
//======================================================
