//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.6 Page 560
//Title: Mass transfer rate
//======================================================

model Ex13_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit = "m") = 1 " Length ";
parameter Real D(unit = "m") = 50e-3 " Diameter ";
parameter Real T(unit = "C") = 25 " Temperature";
parameter Real P(unit = "atm") = 1 " Pressure ";
parameter Real Pa[2](unit = "atm") = {0.25,0.125} " Partial pressure at both ends";
parameter Real DAB(unit= "m^2/s")=0.16e-4 " Diffusion coefficient ";//Obtained from table 13.3 on pg 549

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nax(unit = " kmol/hour ") "Mass transfer rate ";
Real A(unit=" m^2") "Area ";
Real MCO2(unit = " kg/hour ") "Mass flow rate of CO2 ";
Real Mair(unit =" kg/hour ") "Mass flow rate of air ";

//=============
// Equation Section

equation

Nax=DAB*(Pa[1]-Pa[2])/((T+273)*8.205e-2*L)*A*3600;
A=(pi/4)*D^2;
MCO2=44*Nax*A*3600;
Mair=29*(-Nax)*A*3600;

end Ex13_6;
//======================================================
