//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.2 Page 576
//Title:  Local mass transfer coefficient
//======================================================

model Ex14_2
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real y[2](unit = "m") = {0,2.5e-3} " Value of y ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Pa[2](unit= "atm")" Partial pressure distribution";
Real dPa(unit= "atm/m")" Partial derivative";
Real hm(unit= "m/s")" Convection mass transfer coefficient";

//=============
// Equation Section

equation

Pa[1]=e^(-33.35*y[1])-0.9;
Pa[2]=e^(-33.35*y[2])-0.9;
dPa=-33.35*e^(y[1])-0.9;
hm=(-DAB)*dPa/(Pa[1]-Pa[2]);


end Ex14_2;
//======================================================
