//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.4 Page 583
//Title: Mass transfer coefficient for Evaporation of Water
//======================================================

model Ex14_4
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "C") = 27 " Temperature";
parameter Real l(unit = "m") = 15 " Length ";
parameter Real u(unit=" m/s")= 2 " Velocity ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";

//Properties of dry air at 300K
parameter Real p1(unit=" kg/m^3")= 0.0436 " Density ";
parameter Real v1(unit="m^2/s")= 15.89e-6 " Kinematic Viscosity ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Sc(unit= "")" Schmidt Number ";
Real Re(unit= "")" Reynolds Number ";
Real Sh(unit= "")" Sherwood Number ";
Real hm(unit= "m/s")" Mass transfer coefficient";

//=============
// Equation Section

equation

Sc=v1/DAB;
Re=(u*l)/v1;
Sh=(0.037*(Re^0.8)-870)*Sc^(1/3);
hm=Sh*(DAB/l);

end Ex14_4;
//======================================================
