//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.5 Page 585
//Title: Average Mass transfer coefficient
//======================================================

model Ex14_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "C") = 25 " Temperature";
parameter Real l(unit = "m") = 1 " Length of tube ";
parameter Real d(unit = "m") = 10e-3 " Diameter of tube ";
parameter Real u(unit=" m/s")= 3 " Velocity ";
parameter Real DAB(unit= "m^2/s")=0.62e-5 " Diffusion coefficient ";//Obtained from table 13.3 on pg 549
parameter Real Sh(unit= "")=3.66 " Sherwood Number ";

//Properties of dry air at 298K
parameter Real v1(unit="m^2/s")= 15.7e-6 " Kinematic Viscosity ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds Number ";
Real hm(unit= "m/s")" Mass transfer coefficient";

//=============
// Equation Section

equation

Re=(u*d)/v1;
hm=Sh*(DAB/d);

end Ex14_5;
//======================================================
