//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.7 Page 589
//Title: Steady state temperature
//======================================================

model Ex14_7
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "K") = 313 " Temperature";
parameter Real Ps(unit = "Pa") = 3530 " Saturated vapour pressure ";
parameter Real hfg(unit=" kJ/kg")= 120 " Latent heat ";
parameter Real W(unit=" kg/kmol")= 100 " Molecular weight";
parameter Real DAB(unit= "m^2/s")=0.2e-4 " Diffusion coefficient ";

//Properties of dry air at 300K
parameter Real p1(unit="kg/m^3")= 1.16 " Density ";
parameter Real a(unit="m^2/s")= 22.5e-6 " Thermal Diffusivity ";
parameter Real Cp(unit="J/kg K")= 1.007 " Specific heat ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real dis(unit="")" Discriminant";
Real Ts(unit="K") " Steady state temperature";

//=============
// Equation Section

equation

dis=(T*T)-4*((hfg*W*1e-3*Ps)/(8.314*p1*Cp*((a/DAB)^(2/3))));
Ts=(T+(dis)^0.5)/2;

end Ex14_7;
//======================================================
