//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.8 Page 590
//Title: True air temperature
//======================================================

model Ex14_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Ts(unit = "K") = 295 " Steady state Temperature";
parameter Real Ps(unit = "Pa") = 2617 " Saturated vapour pressure ";
parameter Real hfg(unit=" kJ/kg")= 2449 " Latent heat ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";
parameter Real p1(unit="kg/m^3")= 1.198 " Density ";
parameter Real a(unit="m^2/s")= 26.2e-6 " Thermal Diffusivity ";
parameter Real Cp(unit="kJ/kg K")= 1.008 " Specific heat ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real p1as(unit="kg/m^3")" Density";
Real T(unit="K") " Actual temperature";
Real Tc(unit="C") " Actual temperature in celsius";


//=============
// Equation Section

equation

p1as=Ps*18/(Ts*8314);
T-Ts=hfg*p1as/(p1*Cp*(a/DAB)^(2/3));
Tc=T-273;

end Ex14_8;
//======================================================
