//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.9 Page 591
//Title: Relative Humidity
//======================================================

model Ex14_9
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit="C")=50 " Air temperature";
parameter Real Ts(unit = "C") = 22 " Wet bulb Temperature";
parameter Real Ps(unit = "Pa") = 2617 " Saturated vapour pressure ";
parameter Real hfg(unit=" kJ/kg")= 2449 " Latent heat ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";
parameter Real p[2](unit="kg/m^3")={0.01920,0.0064}" Density";

//Properties at film temperature of 36 degree celsius
parameter Real p1(unit="kg/m^3")= 1.14 " Density ";
parameter Real Cp(unit="kJ/kg K")= 1.006 " Specific heat ";
parameter Real v1(unit="Pa s")= 2e-5 " Viscosity ";
parameter Real Pr(unit="")= 0.7" Prandtl Number ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Sc(unit="")" Schmidt Number ";
Real Le(unit="")" Lewis Number ";
Real RH(unit="")" Relative Humidity ";

//=============
// Equation Section

equation

Sc=v1/(p1*DAB);
Le=Sc/Pr;
RH=100*(p[2]/0.0817);

end Ex14_9;
//======================================================
