//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.10 Page 65
//Title: Heat Transfer through Composite Wall
//======================================================

model Ex3_10
//=============
// Parameter Section

parameter Real  T1(unit = " C ") = 800  " Inside Wall Temperature ";
parameter Real  T2(unit = " C ") = 100  " Outside Wall Temperature "; 
parameter Real  La(unit = " m ") = 0.05 " Thickness of A ";
parameter Real  Lb(unit = " m ") = 0.10 " Thickness of B ";
parameter Real  Lc(unit = " m ") = 0.10 " Thickness of C ";
parameter Real  Ld(unit = " m ") = 0.05 " Thickness of D ";
parameter Real  Le(unit = " m ") = 0.05 " Thickness of E ";
parameter Real  Ka(unit = " W/m C ") = 50 " Thermal Conductivity of A  ";
parameter Real  Kb(unit = " W/m C ") = 10 " Thermal Conductivity of B  ";
parameter Real  Kc(unit = " W/m C ") = 6.67 " Thermal Conductivity of C  ";
parameter Real  Kd(unit = " W/m C ") = 20  " Thermal Conductivity of D  ";
parameter Real  Ke(unit = " W/m C ") = 30  " Thermal Conductivity of E  ";


//=============
// Variable Section

Real Ra(unit= "W/C") " Heat Transfer Resistance of A ";
Real Rb(unit= "W/C") " Heat Transfer Resistance of B ";
Real Rc(unit= "W/C") " Heat Transfer Resistance of C ";
Real Rd(unit= "W/C") " Heat Transfer Resistance of D ";
Real Re(unit= "W/C") " Heat Transfer Resistance of E ";
Real Rf(unit= "W/C") " Equivalent Heat Transfer Resistance of B and C ";
Real R(unit= "W/C") " Total Heat Transfer Resistance ";
Real Q(unit= "kW") " Total Heat Transfer ";

//=============
// Equation Section

equation

Ra=La/Ka*1;
Rb=Lb/(Kb*0.5);
Rc=Lc/(Kc*0.5);
Rd=Ld/Kd*1;
Re=Le/Ke*1;
Rf=(Rb*Rc)/(Rb+Rc);
R=Ra+Rf+Rd+Re;
Q=(T1-T2)/(1000*R);

end Ex3_10;
//======================================================
