//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.13 Page 70
//Title: Heat Loss from Insulated Pipe
//======================================================

model Ex3_13
extends Modelica.Math;
//=============
// Parameter Section

parameter Real id (unit = " m ") = 0.1  " ID of pipe ";
parameter Real t  (unit = " m ") = 0.01  " Wall Thickness "; 
parameter Real ti (unit = " m ") = 0.03  " Insulation Thickness ";
parameter Real T[2] (unit = " C ") = {85,25}   " Respective Temperatures ";
parameter Real k[2] (unit = " W/m K ") ={ 58,0.2}   " Respective Thermal Conductivities ";
parameter Real h[2] (unit = " W/m^2 K ") = {720,9} " Inside & Outside Heat transfer coefficient";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section
Real Q(unit= "W/m") " Heat Transfer Rate per unit length ";

//=============
// Equation Section

equation

Q= (2*pi*(T[1]-T[2]))/( (1/((id/2)*h[1])) + (1/(h[2]*ti*3)) + (log((2*ti)/(id/2))/k[1]) + (log((3*ti)/(2*ti))/k[2]) );


end Ex3_13;
//======================================================
