//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.16 Page 73
//Title: Mass of Steam Condensed
//======================================================

model Ex3_16
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T (unit = " C ") = 20 " Temperature under canvas ";
//Values of Saturation temperature & Latent Heat taken from Table A.6(Appendix A) at 1373kPa @ page 644
parameter Real Ts (unit = " C ") = 194.14 " Saturation Temperature of Steam ";
parameter Real hfg (unit = " kJ/kg ") = 1963.15 " Latent Heat Of Steam ";
parameter Real k[2] (unit = " W/ m K ") ={ 0.07,0.08}   " Respective Thermal Conductivities ";
parameter Real r[3] (unit = " m ") = {0.05,0.1,0.125} " Respective radii from steam pipe line";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
parameter Real l (unit = " m ") = 150 " Length of pipeline ";

//=============
// Variable Section

Real Q(unit= "W") " Heat Transfer Rate ";
Real Qh(unit= "kJ/hr") " Heat Transfer Rate per hour ";
Real m(unit= " kg ") "Mass of Steam condensed in 12 hours ";

//=============
// Equation Section

equation

Q=(2*pi*(Ts-T)*l)/( (log(r[2]/r[1])/k[1])+(log(r[3]/r[2])/k[2]) );
Qh=Q*3600/1000;
m=Qh*12/hfg;

end Ex3_16;
//======================================================
