//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.20 Page 83
//Title: Surface and Maximum Temperatures
//======================================================

model Ex3_20
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T (unit = " C ") = 20 " Ambient Temperatures ";
parameter Real k (unit = " W/ m K ") = 15 "  Thermal Conductivity of wall ";
parameter Real h (unit = " W/ m^2 K ") = 50 " Heat Transfer coefficient between air & insulation ";
parameter Real l (unit = " m ") = 0.1 " Thickness of wall ";
parameter Real Q (unit = " W/m^3 ") = 4E4 " Heat generation rate "; 
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;


//=============
// Variable Section

Real Tw(unit= " C ") " Surface temperature ";
Real Tmax(unit= " C ") " Maximum Wall Temperature ";
 
//=============
// Equation Section

equation

Tw= T + ((Q*l)/(2*h));
Tmax= Tw + ((Q*(l^2))/(8*k));
  

end Ex3_20;
//======================================================
