//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.22 Page 88
//Title: Surface Temperature And Heat Transfer Coefficient of Current Carrying Tube
//======================================================

model Ex3_22
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {200,10}   " Surface and Ambient Temperatures ";
parameter Real k (unit = " W/ m K ") = 160 "  Thermal Conductivity of the material ";
parameter Real I(unit =" A ") = 200 " Current ";
parameter Real r (unit = " m ") = 0.0125 " Radius of the transmission line ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
parameter Real R (unit= "ohm /cm") = 0.4*10^(-4) "Electrical Resistance Per unit length ";

//=============
// Variable Section

Real h (unit = " W/ m^2 K ") " Heat Transfer coefficient between wire surface and ambient air ";
Real Tc(unit= " C ") " Surface temperature ";
Real Q(unit= " W/m ") " Heat loss per unit length ";
Real q(unit= " W/m^2 ") " Heat loss per area ";
 
//=============
// Equation Section

equation

Q=(I^2)*R*100;
q=Q/(pi*r*r);
Tc= T[1] +(q*(r^2))/(4*k);
h=(r*q)/(2*(T[1]-T[2]));


end Ex3_22;
//======================================================
