//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.25 Page 95
//Title: Temperature at centre of orange
//======================================================

model Ex3_25
extends Modelica.Math;
//=============
// Parameter Section

parameter Real r (unit = " m ") = 0.04 " Radius of orange ";
parameter Real k (unit = " W/ m K ") = 0.15 " Thermal Conductivity of the orange ";
parameter Real Q (unit = "W/m^2 ") = 300 " Heat produced ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real q0(unit= "W/m^2") " Heat Transfer Rate ";
Real T (unit= "C") " Temperature at centre ";
//=============
// Equation Section

equation
q0=3*Q/r;
T=10+ (q0*r*r)/(6*k);

end Ex3_25;
//======================================================
//Note: Outer temperature (T0) of the orange is not mentioned. It is assumed as 10 as in the book.
