//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.29 Page 104
//Title: Fin with convection of the ends
//======================================================

model Ex3_29
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {150,45}   " Surface and Ambient Temperature ";
parameter Real w (unit = " m ") = 1 " Length of the cylinder ";
parameter Real L (unit = " m") = 1.27*10^(-2) " Height of fin ";
parameter Real t (unit = " m") = 0.76*10^(-3) " Thickness of fin ";
parameter Real d (unit = " m") = 0.05 " Diameter of cylinder ";
parameter Real k (unit = "W/ m K") = 120 " Thermal Conductivity of the rod ";
parameter Real h (unit = "W/m^2 K") = 17 " Heat transfer coefficient ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159275358979;

//=============
// Variable Section

Real a (unit= "m^2") " Area of the cylinder ";
Real p (unit= "m") " Perimeter of the cylinder ";
Real m(unit = " ") "Value of m";
Real Qfin( unit = "W ") "Heat Transfer per fin ";
Real Qb(unit = "W ") "Heat Transfer from base surface ";
Real Qtotal(unit = "W ") "Total Heat Transfer ";
Real Tend(unit = " C ") " Temperature at the end ";

//=============
// Equation Section
equation

a=w*t;
p=2*w;
m=((h*p)/(k*a))^0.5;
Qfin=(h*p*k*a)^0.5*(T[1]-T[2])*((tanh(m*L)+(h/(m*k)))/(1+(h*tanh(m*L)/(m*k))));
Qb=h*((pi* d) -(10*t))*w*(T[1]-T[2]);
Qtotal=Qb+(10*Qfin);
Tend =((T[1]-T[2])/(cosh(m*L)+((h*sinh(m*L))/(m*k)))) + T[2];

end Ex3_29;
//======================================================
