//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.32 Page 116
//Title: Fin efficiency
//======================================================

model Ex3_32
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = "m") = 0.015  "Length of the fin ";
parameter Real t (unit = "m") = 0.002  "Thickness of the fin ";
parameter Real h[2](unit = "W/m^2 K ")={285,510} "Heat transfer coefficient of aluminium and steel respectively";
parameter Real k[2](unit = "W/m K ") = {210,40} "Thermal Conductivity of aluminium and steel respectively ";

//=============
// Variable Section

Real Lc(unit = "m") "Length correction of the fin ";
Real eta[2](unit= "") " Efficiencies of respective metals ";
Real mLc1(unit= "")  " Value of mLc for aluminium";
Real mLc2(unit= "")  " Value of mLc for steel";
     
//=============
// Equation Section

equation

Lc=L+(t/2);
mLc1=Lc*((2*h[1])/(k[1]*t))^0.5;
mLc2=Lc*((2*h[2])/(k[2]*t))^0.5;
eta[1]=tanh(mLc1)/mLc1;
eta[2]=tanh(mLc2)/mLc2;

end Ex3_32;
//======================================================
