//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.11 Page 178
//Title: Time required and depth
//======================================================

model Ex5_11
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real a1(unit="m^2/hour")=0.405 " Thermal Diffusivity";
parameter Real Ti(unit="C")=100 " Initial temperature";
parameter Real Tf(unit="C")=0 " Final temperature";
parameter Real t2(unit="min")=1 " Time";
parameter Real dTx(unit="C/m")=400 " Temperature gradient";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real t(unit="hour")" Time ";
Real x(unit="m")" Depth at maximum rate of cooling";

//=============
// Equation Section

equation

(Ti-Tf)/(pi*a1*t)^0.5=dTx;
x=(2*a1*t2/60)^0.5;

end Ex5_11;
//======================================================
