//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.12 Page 185
//Title: Temperature and total thermal energy
//======================================================

model Ex5_12
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit="m")=5e-2 "Length";
parameter Real a1(unit="m^2/s")=8.4e-5 " Thermal Diffusivity";
parameter Real k(unit="W/mK")=215 " Thermal Conductivity";
parameter Real p1(unit="m^2/s")=2700 " Density";
parameter Real c(unit="J/kg K")=900 " Specific Heat";
parameter Real Ti(unit="C")=500 " Initial temperature";
parameter Real Tf(unit="C")=100 " Final temperature";
parameter Real t(unit="min")=1 " Time";
parameter Real h(unit="W/m^2 K")=1200 " Heat transfer coefficient";
parameter Real T1c(unit="")=0.68 " Value obtained from Fig5.7 on pg 183";
parameter Real T1s(unit="")=0.88 " Value obtained from Fig5.8 on pg 184";
parameter Real UUo(unit="")=0.32 " Ratio of U by Uo obtained from Fig 5.9 on pg 185 ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tc(unit="C")" Temperature of centreline";
Real Ts(unit="C")" Temperature of surface";
Real U(unit="J/m^2")" Thermal energy removed per unit area";

//=============
// Equation Section

equation

(Tc-Tf)/(Ti-Tf)=T1c;
(Ts-Tf)/(Tc-Tf)=T1s;
U=p1*c*2*L*(Ti-Tf)*UUo;

end Ex5_12;
//======================================================
