//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.14 Page 189
//Title: Time required to cool
//======================================================

model Ex5_14
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real ro(unit="m")=10e-3 " Radius";
parameter Real a1(unit="m^2/s")=6.66e-6 " Thermal Diffusivity";
parameter Real k(unit="W/mK")=20 " Thermal Conductivity";
parameter Real c(unit="J/kg K")=1000 " Specific Heat";
parameter Real p1(unit="kg/m^3")=3000 " Density";
parameter Real Ti(unit="C")=400 " Initial temperature";
parameter Real Ta(unit="C")=20 " Air temperature";
parameter Real Tc(unit="C")=335 " Centre temperature";
parameter Real Tf(unit="C")=50 " Final temperature";
parameter Real h(unit="W/m^2 K")=10 " Heat transfer coefficient";
parameter Real Fo(unit="")=0.5 " Fourier No obtained from Fig5.13 on pg 190";
parameter Real T1w(unit="")=0.33 " Value obtained from Fig5.14 on pg 191";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tw(unit="C")" Temperature after cooling in water";
Real t1(unit="s")" Time for air cooling";
Real t2(unit="s")" Time for water cooling";

//=============
// Equation Section

equation

(Tc-Ta)/(Ti-Ta)=e^(-(3*h*t1)/(p1*ro*c));
Fo=a1*t2/(ro*ro);
(Tw-Ta)/(Tf-Ta)=T1w;

end Ex5_14;
//======================================================
