//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.16 Page 196
//Title: Centreline temperature
//======================================================

model Ex5_16
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit="m")=160e-3 " Length";
parameter Real d(unit="m")=80e-3 " Diameter";
parameter Real k(unit="W/mK")=23.5 " Thermal Conductivity";
parameter Real h(unit="W/m^2 K")=120 " Convective Heat transfer coefficient";
parameter Real a1(unit="m^2/hour")=0.022 " Thermal diffusivity";
parameter Real Tf(unit="C")=30 " Medium temperature";
parameter Real Ti(unit="C")=800 " Initial temperature";
parameter Real t(unit="hour")=0.5 " Time";
parameter Real Cr(unit="")=0.068 " Solution of infinite cylinder";//From fig5.10 on pg 187
parameter Real Px(unit="")=0.54 " Solution of infinite plate";//From fig5.7 on pg 183

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Foc(unit="") " Fourier no of cylinder";
Real Fop(unit="") " Fourier no of plate";
Real B1(unit="") " h/kl for cylinder";
Real B2(unit="") " h/kl for plate";
Real T(unit="C")" Centreline temperature";

//=============
// Equation Section

equation

Foc=a1*t/(d/2)^2;
Fop=a1*t/(L/2)^2;
B1=k/(h*(d/2));
B2=k/(h*L/2);
(T-Tf)/(Ti-Tf)=Px*Cr;

end Ex5_16;
//======================================================
