//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.19 Page 205
//Title: Time elapsed
//======================================================

model Ex5_19
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=0.6 " Thickness";
parameter Real dx(unit="m")=0.1 " Incremental thickness";
parameter Real a1(unit="m^2/hour")=1.66e-3 " Thermal diffusivity";
parameter Real T1[2](unit="C")={150,300} " Temperatures at end";
parameter Real Ti(unit="C")=20 " Initial temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real t(unit="hour") " Time";

//=============
// Equation Section

equation

t=9*(dx)^2/(2*a1);

end Ex5_19;
//======================================================
