//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.20 Page 206
//Title: Temperature
//======================================================

model Ex5_20
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=20e-3 " Thickness";
parameter Real dx(unit="m")=2e-3 " Incremental thickness";
parameter Real a1(unit="m^2/hour")=0.833e-7 " Thermal diffusivity";
parameter Real k(unit="W/mK")=0.175 " Thermal conductivity";
parameter Real h(unit="W/m^2 K")=65 " Heat transfer coefficient";
parameter Real T2(unit="C")=20 " Temperature";
parameter Real T1(unit="C")=144 " Temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real dt(unit="s") " Time";
Real dx1(unit="m") " Convective film thickness";
Real Tc(unit="C") " Centre Temperature after 4min";
Real Ts(unit="C") " Surface Temperature after 4min";

//=============
// Equation Section

equation

Tc=114;
Ts=50;
dt=(dx)^2/(2*a1);
dx1=k/h;

end Ex5_20;
//======================================================
