//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.4 Page 165
//Title: Time taken to cool
//======================================================

model Ex5_4
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real m(unit="kg")=5.5 " Mass of sphere";
parameter Real k(unit="W/mK")=205 " Thermal Conductivity";
parameter Real h(unit="W/m^2 K")=58 " Convective Heat transfer coefficient";
parameter Real c(unit="J/kg K")=900 " Specific heat";
parameter Real p1(unit="kg/m^3")=2700 " Density";
parameter Real To(unit="C")=290 " Uniform temperature";
parameter Real Ti(unit="C")=15 " Liquid temperature";
parameter Real T(unit="C")=95 " Aluminium temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real r(unit="m") " Radius";
Real V(unit="m^3") " Volume";
Real Lc(unit="m") " Corrected length";
Real t(unit="s") " Time";

//=============
// Equation Section

equation

V=m/p1;
V=(4/3)*pi*(r^3);
Lc=r/3;
((T-Ti)/(To-Ti))=e^(-(3*h*t)/(p1*c*r));

end Ex5_4;
//======================================================
