//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.8 Page 177
//Title: Temperature and total heat 
//======================================================

model Ex5_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=0.2 " Thickness";
parameter Real k(unit="W/mK")=0.8 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=0.003 " Thermal Diffusivity";
parameter Real To(unit="C")=25 " Initial temperature";
parameter Real Ts(unit="C")=800 " Final temperature";
//parameter Real erf(unit="")=0.585 " Error function"; //Obtained from table 5.1 on pg 175
parameter Real t(unit="hour")=10 " Time";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Qi(unit="W/m^2") " Instantaneous heat flow rate per unit area";
Real Q(unit="J/m^2") " Total heat energy taken by the wall";
Real T(unit="C")" Temperature";

//=============
// Equation Section

equation

(Ts-T)/(Ts-To)=Special.erf(x/(2*(a1*t)^0.5));
Qi=-k*((To-Ts)/((pi*a1*t)^0.5))*e^(-x*x/(4*a1*t));
Q=(2*k*(Ts-To))*((t/(pi*a1))^0.5)*3600;

end Ex5_8;
//======================================================
