//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-6: Fundamentals of Convective Heat Transfer
//Example: 6.2 Page 241
//Title: Type of Flow
//======================================================

model Ex6_2
extends Modelica.Math;
//=============
// Parameter Section

parameter Real l (unit = " m ") = 1 " Length of the plate ";
parameter Real w (unit = " m ") = 1 " Width of the plate ";
parameter Real rho( unit = "kg/m^3 ")= 1.12 " Density of air ";
parameter Real myu( unit = "kg/m s ")= 0.85e-5 " Viscosity of air ";
parameter Real Re ( unit = "") = 5e5 " Critical Reynold Number ";
parameter Real u ( unit = "m/s") = 2.5 " Velocity of air ";

//=============
// Variable Section

Real x (unit = " m ")  " Critical Length of the plate ";

//=============
// Equation Section

equation

x= myu*Re/(rho*u);

//Since actual length of the plate L is 1m, that is less than x, the flow is laminar over the entire length of the plate.

end Ex6_2;
//======================================================
