//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.1 Page 275
//Title: Thickness of boundary layer and skin friction coefficient
//======================================================

model Ex7_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit = "m") = 0.4 " Distance of plane from the plate  ";
parameter Real v1(unit = "m^2/s") = 15.06e-6 " Kinematic viscosity";
parameter Real u(unit="m/s")=3 " Velocity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real d(unit= "m")" Boundary layer thickness ";
Real Cfx(unit= "")" Skin friction ";

//=============
// Equation Section

equation

Re=x*u/v1;
d=5*x/(Re^0.5);
Cfx=0.664/(Re^0.5);

end Ex7_1;
//======================================================
