//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.13 Page 304
//Title: Zhukauskas Correlation
//======================================================

model Ex7_13
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=6 " Velocity";
parameter Real T1(unit="C")=70 " Temperature of surface";
parameter Real T2(unit="C")=15 " Air Temperature";
parameter Real d(unit="m")=16.4e-3 " Dimension";
parameter Real ST(unit="m")=0.0205 " Transverse Pitch";
parameter Real SL(unit="m")=0.0205 " Longitudinal Pitch";
parameter Real N(unit="")=7 " No of rows";

//Properties of air at film temperature 15C
parameter Real v1(unit = "m^2/s") = 14.82e-6 " Kinematic viscosity";
parameter Real Pr(unit="")=0.710 " Prandtl number";
parameter Real Prs(unit="")=0.701 " Prandtl number at 70C";
parameter Real k(unit="W/m K")=0.0253 " Thermal conductivity";
parameter Real p1(unit="kg/m^3")=1.217 " Density";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real umax(unit="m/s")" Velocity";
Real Remax(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient circular tube";
Real Nu(unit= "")" Nusselt no";

//=============
// Equation Section

equation

umax=u*ST/(ST-d);
Remax=umax*(d/v1);
Nu=h*d/k;
Nu=0.35*((ST/SL)^(0.2))*(Remax^0.6)*(Pr/Prs)^0.25;

//The value obtained is about 10% more than that in Ex7.12

end Ex7_13;
//======================================================
