//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.16 Page 311
//Title:  Length and heat transfer coefficient
//======================================================

model Ex7_16
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real m(unit="kg/min")=5 " Mass flow rate";
parameter Real T1(unit="C")=80 " Temperature of surface";
parameter Real Tw[2](unit="C")={20,70} " Water inlet and outer temperatures";
parameter Real Di(unit="m")=25e-3 " Inner Diameter";
parameter Real Do(unit="m")=40e-3 " Outer Diameter";
parameter Real q(unit="W/m^3")=1e7 " Rate of heat generation";
parameter Real Cp(unit="kJ/kgK")=4.179 " Specific heat of water at 45C";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real L(unit="m")" Length of tube";
Real h(unit= "W/m^2 K")" Heat transfer coefficient ";
Real qs(unit="W/m^2") " Heat Flux at surface";

//=============
// Equation Section

equation

q*(pi/4)*((Do*Do)-(Di*Di))*L=(m/60)*Cp*1e3*(Tw[2]-Tw[1]);
q*(pi/4)*((Do*Do)-(Di*Di))*L=qs*pi*Di*L;
h=qs/(T1-Tw[2]);

end Ex7_16;
//======================================================
