//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.7 Page 290
//Title: Friction and heat transfer coefficient 
//======================================================

model Ex7_7
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=75 " Velocity";
parameter Real T1(unit="C")=90 " Temperature of plate";
parameter Real T2(unit="C")=0 " Air Temperature";
parameter Real l[2](unit="m")={0.45,0.6} " Dimensions";
parameter Real P(unit="Pa")=8e3 " Pressure ";
parameter Real Rec(unit="")=5e5 " Critical Reynolds no ";

//Properties of air at film temperature 45C
parameter Real v1(unit = "m^2/s") = 17.45e-6 " Kinematic viscosity";
parameter Real Pr(unit="")=0.698 " Prandtl number";
parameter Real k(unit="W/m K")=2.8e-2 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real xc(unit="m")" Critical length";
Real Re(unit= "")" Reynolds no";
Real hl(unit= "W/m^2 K")" Heat transfer coefficient";
Real Cfl(unit= "")" Skin friction ";
Real Nu(unit= "")" Nusselt no";
Real Q(unit= "kW")" Energy dissipation";

//=============
// Equation Section

equation

Rec=xc*u/v1;
Re=l[1]*u/v1;
hl=Nu*k/l[1];
Cfl=(0.074/(Re^0.2))-(1740/Re);
Nu=((0.037*(Re^0.8))-870)*Pr^(1/3);
Q=2*hl*l[1]*l[2]*(T1-T2)/1000;

end Ex7_7;
//======================================================
