//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.14 Page 356
//Title: Heat transfer rate of a panel surface
//======================================================

model Ex8_14
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real l (unit = " m ") = 25.4e-3 " Thickness of slot ";
parameter Real T[2]( unit = " C ")= {15.6,60} " Temperatures of upper and lower panel respectively";

//Surface properties at 37.8 degree celsius

parameter Real k (unit = " W/m C ") = 29.2e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 0.171e-4 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.7 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = " C") " Film Temperature ";
Real Gr(unit ="") " Grashof Number ";
Real Nu( unit = "") " Nusselt Number ";
Real Q(unit = " W/m^2") " Heat Loss per unit area ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Gr= (g_n*B*(l^3)*(T[2]-T[1]))/(v1^2);
Nu=0.195*(Gr^0.25);
Q=Nu*k*(T[2]-T[1])/l;

end Ex8_14;
//======================================================
