//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.5 Page 345
//Title: Rate of heat input
//======================================================

model Ex8_5
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.8 " Length of the plate";
parameter Real w (unit = " m ") = 0.08 " Width of the plate";
parameter Real T[2]( unit = " C ")= {70,130} " Temperatures of water and plate ";

//Surface properties at 100 degree celsius
parameter Real B (unit = " K^-1 ")=0.75e-3" Volumetric Coefficient of water ";
parameter Real a (unit = " m^2/s ") = 1.68e-7 " Thermal Diffusivity of water ";
parameter Real k (unit = " W/m C ") = 0.68 " Thermal Conductivity of water ";
parameter Real v1 (unit = " m^2/s ") = 0.294e-6 " Kinematic Viscosity of water ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Lc(unit = " m ")" Characteristic length of the plate";
Real Tf(unit = "C") " Film Temperature ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu[2]( unit = "") " Nusselt Number ";
Real h[2](unit = "W/m^2 C") " Average heat transfer coefficient ";
Real Q(unit = "W") " Rate of heat input ";

//=============
// Equation Section

equation

Lc=w/2;
Tf=(T[1]+T[2])/2;
Ra= (g_n*B*(Lc^3))*(T[2]-T[1])/(v1*a);
Nu[1]=0.15*(Ra^(1/3));
h[1]=Nu[1]*k/Lc;
Nu[2]=0.27*(Ra^(1/4));
h[2]=Nu[2]*k/Lc;
Q=(h[1]+h[2])*w*L*(T[2]-T[1]);

end Ex8_5;
//======================================================
