//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.7 Page 391
//Title: Rate of absorbtion and emission
//======================================================

model Ex9_7
extends Modelica.Math;
//=============
// Parameter Section

parameter Real e(unit = "") = 0.8 "Emissivity ";
parameter Real a(unit = "") = 0.52 "Absorptivity ";
parameter Real T (unit = "C") = 37 " Temperature of the bar ";
parameter Real Ti (unit = "K") = 1100 " Temperature of interior ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";

//=============
// Variable Section

Real Q (unit = "kW/m^2") " Rate of absorbtion ";
Real E (unit = "kW/m^2") " Rate of emission ";


//=============
// Equation Section

equation

Q=a*sigma*(Ti^4)/1000;
E=e*sigma*((T+273)^4)/1000;

end Ex9_7;
//======================================================
