//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.7 Page 21
//Title: Immersion Water Heater
//======================================================

model Ex1_7
//=============
// Parameter Section

parameter Real A(unit = "m^2") = 0.1 " Surface Area ";
parameter Real Q(unit = "W") = 1000 " Rating of the heater ";
parameter Real T(unit = "C") = 40 " Temperature of the fluid";
parameter Real h1(unit = "W/m^2 C") = 300 " Heat Transfer Coefficient in water ";
parameter Real h2(unit = "W/m^2 C") = 9 " Heat Transfer Coefficient in air ";


//=============
// Variable Section

Real Ts1(unit = "C")  " Surface Temperature when used in water";
Real Ts2(unit = "C")  " Surface Temperature when used in air";

//=============
// Equation Section

equation

Ts1= (Q/(A*h1))+T;
Ts2= (Q/(A*h2))+T;

end Ex1_7;
//======================================================
