//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.15 Page 430
//Title: Radiant heat exchange
//======================================================

model Ex10_15
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1073 " Temperature of first plate";
parameter Real T2(unit="K")=573 " Temperature of second plate";
parameter Real d(unit="m")=0.2 " Diameter";
parameter Real L(unit="m")=2 " Length of side of square";
parameter Real e1(unit="")=0.3 " Emissivity of first plate";
parameter Real e2(unit="")=0.5 " Emissivity of second plate";
parameter Real F(unit="")=0.014 " Shape factor";//Value obtained from Fig 10.4 on pg 409

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real ee(unit="") " Equivalent Emissivity ";
Real Q(unit="W")" Heat transferred";

//=============
// Equation Section

equation

ee=e1*e2;
Q=ee*sigma*(pi*d*d/4)*F*((T1^4)-(T2^4));

end Ex10_15;
//======================================================
