//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.18 Page 432
//Title: Loss of heat
//======================================================

model Ex10_18
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=303 " Temperature of air";
parameter Real T2(unit="K")=673 " Temperature of pipe";
parameter Real D(unit="m")=20e-2 " Diameter";
parameter Real e1(unit="")=0.8 " Emissivity";
parameter Real e2(unit="")=0.91 " Emissivity of brick conduit";
parameter Real D1(unit="m")=40e-2 " Diameter of brick conduit";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q12(unit="W/m")" Heat loss";
Real Q12n(unit="W/m")" New Heat loss";
Real Qloss(unit="W/m")" Reduction in Heat loss";
Real ee(unit="")" Equivalent Emissivity ";

//=============
// Equation Section

equation

Q12=sigma*e1*(pi*D)*((T2^4)-(T1^4));
(1/ee)=(1/e1)+((D/D1)*((1/e2) - 1));
Q12n=sigma*ee*(pi*D)*((T2^4)-(T1^4));
Qloss=Q12-Q12n;

//Error in unit of heat loss. It is given as W/m^2 when instead it is W/m

end Ex10_18;
//======================================================
