//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.31 Page 463
//Title: Net radiation exchange and coefficient of heat transfer
//======================================================

model Ex10_31
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Tg(unit="K")=1223 " Temperature of gas";
parameter Real Tw(unit="K")=773 " Temperature of wall";
parameter Real Pt(unit="atm")=1 " Total pressure ";
parameter Real pCO2(unit="atm")=0.1 " Percentage of CO2";
parameter Real pH2O(unit="atm")=0.04 " Percentage of H2O";
parameter Real d(unit="m")=44e-3 " Diameter";
parameter Real ew(unit="")=0.8 " Emissivity of tube";
parameter Real eCO2(unit="")=0.05 " Emissivity of CO2";//From Fig10.23 on pg 458
parameter Real eH2O(unit="")=0.0105 " Emissivity of H2O";//From Fig10.24 on pg 459
parameter Real B(unit="")=1.05 " Correction factor";//From Fig10.28 on pg 461

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Lms(unit="m") " Mean beam length";
Real pLmsCO2(unit="atm m") " Value of pLms";
Real pLmsH2O(unit="atm m") " Value of pLms";
Real e(unit="") " Emissivity of gas";
Real A(unit="")" Absorptivity";
Real Q(unit="W/m^2") " Heat transfer rate";
Real h(unit="W/m^2 K") " Heat transfer coefficient";

//=============
// Equation Section

equation

Lms=3*d;
pLmsCO2=pCO2*Lms;
pLmsH2O=pH2O*Lms;
e=eCO2+(B*eH2O);
A=0.056*((Tg/Tw)^0.65)+B*(0.021);
Q=0.5*(ew+1)*sigma*((e*(Tg^4))-(A*(Tw^4)));
h=Q/(Tg-Tw);

end Ex10_31;
//======================================================
