//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.3 Page 481
//Title: Power Dissipation in Heater
//======================================================

model Ex11_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real D(unit = " m ") = 1.6e-3 " Diameter of wire "; 
parameter Real T(unit = "C") =255 " Temperature difference ";
parameter Real Tsat(unit = "C") =100 " Temperature saturated ";
parameter Real Ts(unit = "C") =355 " Temperature of surface ";
parameter Real den[2](unit = "kg/m^3") ={957.9,31.54}" Density of liquid and vapour respectively ";
parameter Real u1(unit = "Pa s") =18.6e-6 " Viscosity of water ";
parameter Real k(unit = "W/m K") =58.3e-3 " Thermal Conductivity ";
parameter Real hfg(unit = "J/kg") =2257e3 " Enthalpy of vapourisation ";
parameter Real Cp(unit = "J/kg K") =4217 " Specific Heat ";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8
    "Stefan-Boltzmann constant (previous value: 5.670400e-8)";

//=============
// Variable Section

Real hr(unit= "W/m^2 K") " Radiative Heat transfer coefficient ";
Real hc(unit= "W/m^2 K") " Convective Heat transfer coefficient ";
Real hm(unit= "W/m^2 K") " Mean Heat transfer coefficient ";
Real Q(unit= "kW/m") " Heat Dissipation rate per unit length ";

//=============
// Equation Section

equation

hc=0.62* (((g_n*k^3*den[2]*(den[1]-den[2])) *(hfg+ 0.4*(Cp*T)))/(u1*D*T))^(0.25);
hr=sigma*((Ts+273)^4-(Tsat+273)^4)/(Ts-Tsat);
hm=hc+(0.75*hr);
Q=hm*pi*D*T*1e-3;

end Ex11_3;
//======================================================
