//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.7 Page 491
//Title: Heat transfer and condensate flow rate
//======================================================

model Ex11_7
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = " C ") = 84 " Surface temperature ";
parameter Real L(unit = " m ") = 2 " Length of tube "; 
parameter Real d(unit = " m ") = 50e-3 " Diameter of tube ";

//Properties of Saturated Vapour at 100 degree celsius
parameter Real Tsat(unit = "C") =100 " Temperature saturated ";
parameter Real pv(unit = "kg/m^3" )=0.596 " Density of steam ";
parameter Real hfg(unit = "kJ/kg" )=2257 " Enthalpy of steam ";

//Saturated Water at Film Temperature of 92 degree celsius
parameter Real pl(unit = "kg/m^3" )=963.4 " Density of water ";
parameter Real ul(unit = "Pa s" )=306e-6 " Viscosity of water ";
parameter Real kl(unit = "W/m K" )=677e-3 " Thermal Conductivity of water ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real hl(unit= "W/m^2 K") " Local Heat transfer coefficient ";
Real m(unit= "kg/hr") " Mass flow rate of condensate ";
Real Re(unit= "") " Film Reynolds number ";
Real Q(unit ="W") " Heat transfer rate ";


//=============
// Equation Section

equation

Re=4*hl*L*(Tsat-T)/(hfg*ul*1e3);
hl=1.13*( (g_n*pl*(pl-pv)*kl^3*hfg*1e3) / (ul*(Tsat-T)*L) )^0.25;
Q=hl*(pi*d*L)*(Tsat-T);
m=Q*3600/(hfg*1e3);

//Error in value of Q. This is because Tsat-T is taken as 16 when it is actually 10. Actual value of Q is 28.6kW.

end Ex11_7;
//======================================================
