//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.11 Page 518
//Title: Number of tubes and number of tubes per pass
//======================================================

model Ex12_11
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Thi(unit = " C ") = 95 " Hot water inlet temperature";
parameter Real mh(unit = " kg/s ") = 2 " Hot water flow rate";
parameter Real mc(unit = " kg/s ") = 4 " Cold water flow rate";
parameter Real Uo(unit = " W/ m^2 K ") =1500 " Overall heat transfer coefficient";
parameter Real Tc[2](unit = " C ") = {38,55} " Cold Water inlet and outlet temperatures respectively ";
parameter Real u(unit="m/s")=35e-2 "Average velocity of water in tubes ";
parameter Real d(unit="m")=2e-2 "Diameter of tubes ";
parameter Real F(unit="")=0.9 "Correction factor referring to Fig 12.9 on pg 514";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tho(unit = " C ") " Hot water outlet temperature";
Real R(unit="") "Temperature Ratio ";
Real P(unit="") "Temperature Ratio ";
Real Q(unit= "W")" Heat transfer rate ";
Real A(unit= "m^2 ")" Total area of heat exchanger ";
Real A1(unit= "m^2 ")" Total flow area of heat exchanger ";
Real A2(unit= "m^2 ")" Total area for 1 shell and 2 tube pass ";
Real Tlmtd(unit = " C ") "Log Mean temperature difference";
Real n(unit="") "No of tubes ";
Real L(unit="m") "Length of tube ";
Real L2(unit="m") "Corrected Length of tube ";

//=============
// Equation Section

equation

mh*(Thi-Tho)=mc*(Tc[2]-Tc[1]);
Tlmtd= ((Thi-Tc[2]) - (Tho-Tc[1]))/log((Thi-Tc[2])/(Tho-Tc[1]));
Q=mh*4186*(Thi-Tho); //Cp=4186J/kg K
Q=Uo*A*Tlmtd;
mc=1000*u*A1;  //Density=1000 kg/m^3  

//For 1 tube pass
A1=n*(pi/4)*d*d;
L=A/(integer(n)*pi*d); //Length assuming n=36

//For 2 tube passes
R=(Thi-Tho)/(Tc[2]-Tc[1]);
P=(Tc[2]-Tc[1])/(Thi-Tc[1]);
A2=Q/(Uo*F*Tlmtd);
L2=A2/(2*integer(n)*d*pi);

/*The Final Result:
Number of tube per pass = 2 
Number of pass = 2 
Length of tube per pass = 1.517m
*/

end Ex12_11;
//======================================================
