//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.18 Page 534
//Title: Diameter and Length of heat exchanger
//======================================================

model Ex12_18
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real LT(unit = "m") = 100 " Total length of the tubes";

//Total Cost=10000+15000D^3*L+2000DL
//Constraint => 50(Pi)D^2L=100
//Optimum diameter obtained by differentiating Cost expression partially wrt diameter

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real D(unit = "m") " Optimum diameter";
Real L(unit = "m") " Optimum length";
Real Cost(unit = "Rupees") " Optimum cost";

//=============
// Equation Section

equation

50*pi*(D*D)*L=LT;
(30000/pi)=4000/(pi*D*D);
Cost=10000+(15000*(D^3)*L)+(2000*D*L);

end Ex12_18;
//======================================================
