//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.5 Page 558
//Title:  Loss of oxygen by diffusion
//======================================================

model Ex13_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real t(unit = "m") = 2.5e-3 " Thickness of rubber pipe";
parameter Real D(unit = "m") = 25e-3 " Diameter of rubber pipe";
parameter Real T(unit = "C") = 25 " Temperature";
parameter Real P(unit = "bar") = 2 " Pressure ";
parameter Real S(unit = "kmol/m^3 bar") = 3.12e-3 " Solubility ";
parameter Real DAB(unit= "m^2/s")=0.21e-9 " Diffusion coefficient ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real CAi(unit = " kmol/ m^3 ") " Concentration on inside surface";
Real Rma(unit = " s m^2 ") "Diffusion resistance ";
Real Qma(unit = " kmol/s ") "Loss of oxygen per metre length ";

//=============
// Equation Section

equation

CAi=P*S;
Rma=log((D+(2*t))/D)/(2*pi*DAB);
Qma=CAi/Rma;

end Ex13_5;
//======================================================
