//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.1 Page 45
//Title: Rate of Heat Loss and internal temperature
//======================================================

model Ex3_1

//=============
// Parameter Section

parameter Real l(unit = "m") = 5 " Length of wall";
parameter Real h(unit = "m") = 4 " Height of wall";
parameter Real t(unit = "m") = 0.25 " Thickness of wall";
parameter Real Ti(unit = "C") = 110 " Temperature of Inner wall";
parameter Real To(unit = "C") = 40 " Temperature of Outer wall";
parameter Real k(unit = "W/m C") = 0.7 " Thermal Conductivity of the wall";
parameter Real x(unit = "m") = 0.2 " Distance of interior point from the inner wall";

//=============
// Variable Section

Real a(unit = "m^2") "Area of the wall";
Real Tx(unit = "C")  " Temperature of the point";
Real Q(unit= "W") " Heat Transfer Rate";

//=============
// Equation Section

equation

a=l*h;

Q= (k*a*(Ti-To))/t;

Tx= ((To-Ti)/t)*x  +  Ti;


end Ex3_1;
//======================================================
