//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.11 Page 66
//Title: Surface Temperature and Convective Conductance
//======================================================

model Ex3_11
//=============
// Parameter Section

parameter Real  T1(unit = " C ") = 2000  " Hot Gas Temperature ";
parameter Real  T2(unit = " C ") = 1000  " Interior Wall Surface Temperature "; 
parameter Real  T4(unit = " C ") = 45    " Room Air Temperature "; 
parameter Real  qr1(unit = " kW/m^2 ") = 23.26 " Heat Flow by Radiation from gases to interior surface ";
parameter Real  qr4(unit = " kW/m^2 ") = 9.3" Heat Flow by Radiation from external surface to surroundings";
parameter Real  h1(unit = " W/m^2 C ") = 11.63 " Convective Heat Transfer Coefficient at interior surface ";
parameter Real  C(unit = " W/m^2 C ") = 58 " Thermal Conductance of the wall ";

//=============
// Variable Section

Real qc1(unit= " kW/m^2") " Heat Transfer by convection ";
Real R(unit= " m^2 C/W ") " Thermal Resistance of wall ";
Real q(unit= " kW/m^2") " Total q entering wall ";
Real h4(unit= " W/m^2 C") " Convective Conductance ";
Real T3(unit = " C ") " External Wall Temperature "; 

//=============
// Equation Section

equation

qc1=h1*(T1-T2)/1000;
q=qc1+qr1;
R=1/C;
T3=T2-(q*1000*R);
h4=(q-qr4)*(1000)/(T3-T4);

end Ex3_11;
//======================================================
