//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.14 Page 71
//Title: Heat Loss and Interphase Temperature
//======================================================

model Ex3_14
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {250,50}   " Inner and Outer Temperatures ";
parameter Real k[3] (unit = " W/ m K ") ={ 50,0.06,0.12}   " Respective Thermal Conductivities ";
parameter Real r[4] (unit = " m ") = {0.05,0.055,0.105,0.155} " Respective distance from the pipe line";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;


//=============
// Variable Section
Real Q(unit= "W/m") " Heat Transfer Rate per unit length ";
Real T3(unit = " C ") " Temperature at required interface ";

//=============
// Equation Section

equation

Q=(2*pi*(T[1]-T[2]))/( (log(r[2]/r[1])/k[1])+(log(r[3]/r[2])/k[2])+(log(r[4]/r[3])/k[3]) );

T3= ((Q*log(r[4]/r[3]))/(k[3]*2*pi)) + T[2];

end Ex3_14;
//======================================================
