//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.15 Page 72
//Title: Change in heat loss
//======================================================

model Ex3_15
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {250,50}   " Inner and Outer Temperatures ";
parameter Real k[3] (unit = " W/ m K ") ={ 50,0.12,0.06}   " Respective Thermal Conductivities ";
parameter Real r[4] (unit = " m ") = {0.05,0.055,0.105,0.155} " Respective distance from the pipe line";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section
Real Q(unit= "W/m") " Heat Transfer Rate per unit length ";

//=============
// Equation Section

equation

Q=(2*pi*(T[1]-T[2]))/( (log(r[2]/r[1])/k[1])+(log(r[3]/r[2])/k[2])+(log(r[4]/r[3])/k[3]) );

/*Comparing the result with the previous example  Ex.3.14, it is seen that the loss of heat is increased by about 18.11%. Since the purpose of insulation is to reduce the loss of heat, it is always better to provide the insulating material with low thermal conductivity on the surface of the tube first. */

end Ex3_15;
//======================================================
